using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using gov.va.med.vbecs.GUI;
using System.Text.RegularExpressions;
using System.Text;
using gov.va.med.vbecs.Common;
using CONTROLS = gov.va.med.vbecs.GUI.controls;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

namespace gov.va.med.vbecs.GUI.controls
{
	/// <summary>
	/// Summary description for DataGridXMatch.
	/// </summary>
	public class DataGridXMatch : System.Windows.Forms.Panel
	{
		private Hashtable resultLookup;
		private System.Windows.Forms.DataGridTableStyle _dgTableStyle;
		private System.Windows.Forms.DataGridTextBoxColumn _dcTextBox;
		private controls.DataGridKeyTrapTextBoxColumn _dcTextKeyTrapCol;
		private gov.va.med.vbecs.GUI.controls.VbecsDataGrid dgXMatch;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.Button btnClear;
		private System.ComponentModel.IContainer components;
		private DataTable _dtXM;
		private string _validEntries;
		private BOL.Division _division;
		private Common.ReactivityPhase _reactivityPhase;
		private controls.ComboBoxLookup cmbBoxComment;
		private string _testingTech;
		private DateTime _testDate;
		private BOL.OrderedTest _testOrder;
		private BOL.OrderedComponent _componentOrder;
		private BOL.Patient _patient = null;
		private bool _partiallyCompleted = false;
		private System.Guid _parentFormGuid = System.Guid.Empty;
		
		/// <summary>
		/// enableInvalidation
		/// </summary>
		public bool enableInvalidation;
		private bool _keyPressEventHandled;

		/// <summary>
		/// CellChanged Event
		/// </summary>
		public event CellChangedEventHandler CellChanged;

		/// <summary>
		/// Constructor
		/// </summary>
		public DataGridXMatch()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();

			InitializeGrid();
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Locking

		/// <summary>
		/// Event needed for locking - signals to the containing form that the user is "doin' stuff"
		/// </summary>
		public event EventHandler UserActivity;

		/// <summary>
		/// Event needed for locking - signals to the containing form that the user is "doin' stuff"
		/// </summary>
		protected void OnUserActivity()
		{
			if (this.UserActivity != null)
				this.UserActivity(this, System.EventArgs.Empty);
		}

		/// <summary>
		/// Guid of the control's container - needed for locking
		/// </summary>
		public System.Guid ParentFormGuid
		{
			get
			{
				if (this._parentFormGuid == System.Guid.Empty)
				{
					throw new BOL.BusinessObjectException("Locking Requirement missing -- ParentFormGuid not set.");
				}
				return(this._parentFormGuid);
			}
			set
			{
				this._parentFormGuid = value;
			}
		}

		#endregion

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DataGridXMatch));
			this.dgXMatch = new gov.va.med.vbecs.GUI.controls.VbecsDataGrid();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.btnClear = new System.Windows.Forms.Button();
			this.cmbBoxComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			((System.ComponentModel.ISupportInitialize)(this.dgXMatch)).BeginInit();
			this.SuspendLayout();
			// 
			// dgXMatch
			// 
			this.dgXMatch.AllowSorting = false;
			this.dgXMatch.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dgXMatch.CaptionFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgXMatch.CaptionText = "Serologic Crossmatch (XM)";
			this.dgXMatch.CaptionVisible = false;
			this.dgXMatch.DataMember = string.Empty;
//			this.dgXMatch.Direction = gov.va.med.vbecs.GUI.controls.GridDirection.Up;
			this.dgXMatch.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgXMatch.HeaderFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgXMatch.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.dgXMatch.Location = new System.Drawing.Point(0, 0);
			this.dgXMatch.Name = "dgXMatch";
			this.dgXMatch.RowHeadersVisible = false;
			this.dgXMatch.Size = new System.Drawing.Size(492, 96);
			this.dgXMatch.TabIndex = 59;
			this.dgXMatch.ToolTipColumn = -1;
			this.dgXMatch.CurrentCellChanged += new System.EventHandler(this.dgXMatch_CurrentCellChanged);
			// 
			// btnClear
			// 
			this.btnClear.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnClear.Image = ((System.Drawing.Image)(resources.GetObject("btnClear.Image")));
			this.btnClear.Location = new System.Drawing.Point(470, 0);
			this.btnClear.Name = "btnClear";
			this.btnClear.Size = new System.Drawing.Size(20, 20);
			this.btnClear.TabIndex = 62;
			this.btnClear.Click += new System.EventHandler(this.btnClear_Click);
			// 
			// cmbBoxComment
			// 
			this.cmbBoxComment.Interval = 500;
			this.cmbBoxComment.Location = new System.Drawing.Point(0, 0);
			this.cmbBoxComment.MaxLength = 255;
			this.cmbBoxComment.Name = "cmbBoxComment";
			this.cmbBoxComment.Size = new System.Drawing.Size(88, 21);
			this.cmbBoxComment.TabIndex = 0;
			// 
			// DataGridXMatch
			// 
			this.Controls.Add(this.btnClear);
			this.Controls.Add(this.dgXMatch);
			this.Name = "DataGridXMatch";
			this.Size = new System.Drawing.Size(492, 96);
			((System.ComponentModel.ISupportInitialize)(this.dgXMatch)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Set or get the division code
		/// </summary>
		public string DivisionCode
		{
			get
			{
				return this._division.DivisionCode;
			}
			set
			{
				if (value != null)
				{
					this._division = new BOL.Division(value);
				}
			}
		}

		/// <summary>
		/// Get the valid entries description for grid cell
		/// </summary>
		public string ValidEntries
		{
			get
			{
				return this._validEntries;
			}
		}

		/// <summary>
		/// Get or set the reactivity phase
		/// </summary>
		public Common.ReactivityPhase ReactivityPhase
		{
			get
			{
				return this._reactivityPhase;
			}
			set
			{
				this._reactivityPhase = value;
			}
		}

		/// <summary>
		/// Get or set the testing tech
		/// </summary>
		public string TestingTech
		{
			get
			{
				return this._testingTech;
			}
			set
			{
				this._testingTech = value;
			}
		}

		/// <summary>
		/// The date of test
		/// </summary>
		public DateTime TestDate
		{
			get
			{
				return this._testDate;
			}
			set
			{
				this._testDate = value;
			}
		}

		/// <summary>
		/// Get the name of the qc rack
		/// </summary>
		public string RackName
		{
			get
			{
				if (this._dtXM.Rows[0].IsNull(TABLE.Rack.RackGuid) == false)
				{
					BOL.Rack rack = new BOL.Rack((Guid)this._dtXM.Rows[0][TABLE.Rack.RackGuid]);
					return rack.RackName;
				}
				else
					return string.Empty;
			}
		}

		/// <summary>
		/// Check if the XM grid exists
		/// </summary>
		public bool GridExists
		{
			get
			{
				if (this._testOrder == null &&
					this._componentOrder == null)
					return false;
				else
					return true;
			}
		}

		/// <summary>
		/// Invoke cell changed event
		/// </summary>
		/// <param name="e"></param>
		protected virtual void OnCellChanged(EventArgs e)
		{
			if (CellChanged != null)
				CellChanged(this.dgXMatch, e);

			this.OnUserActivity();
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Calls the method to create a hash table of testing results, creates the blood unit test table, 
		/// populates the table with the selected units, and sets the current cell to allow editing.
		/// </summary>
		private void InitializeGrid()
		{
			this.dgXMatch.CaptionVisible = true;
			// 
			// cmbBoxComment
			// 
			this.cmbBoxComment.Name = "cmbBoxComment";
			this.cmbBoxComment.TabIndex = 0;
			this.cmbBoxComment.Width = 93;
			this.cmbBoxComment.Validating += new System.ComponentModel.CancelEventHandler(this.cmbBoxComment_Validating);
			this.cmbBoxComment.LookupEnabled = false;
			//
			this.dgXMatch.LostFocus +=new EventHandler(dgXMatch_LostFocus);
			this.dgXMatch.SizeChanged += new System.EventHandler(this.dgXMatch_SizeChanged);
			this.dgXMatch.NextCell += new controls.NextCellEventHandler(SetNextCell);
			this.dgXMatch.Leave += new EventHandler(dgXMatch_Leave);
			this.dgXMatch.Enter += new EventHandler(dgXMatch_Enter);
			//
			InitializeLookup();
			AddCustomDataTableStyle();
			this._keyPressEventHandled = false;
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Creates a hash table of testing results.
		/// </summary>
		private void InitializeLookup()
		{
			// Fill hashtable with the "Positive" and "Negative" values of each test result
			resultLookup = new Hashtable();

			// Empty results
			resultLookup.Add("", "");
			resultLookup.Add("X", "X");
			
			// Positive results
			resultLookup.Add("W", "P");
			resultLookup.Add("F", "P");
			resultLookup.Add("M", "P");
			resultLookup.Add("1", "P");
			resultLookup.Add("2", "P");
			resultLookup.Add("3", "P");
			resultLookup.Add("4", "P");

			// Negative results
			resultLookup.Add("R", "N");
			resultLookup.Add("0", "N");
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Creates the blood unit test data table. 
		/// </summary>
		/// <param name="xmTest"></param>
		/// <param name="rackGuid"></param>
		/// <param name="lastUpdateFunctionId"></param>
		/// <returns></returns>
		public DataTable CreateXMTable(object xmTest, Guid rackGuid, Common.UpdateFunction lastUpdateFunctionId)
		{
			_testOrder = null;
			_componentOrder = null;
			DataTable dtOrderedUnits = new DataTable();
			bool IsOnlyXMatch;
			DataTable dtBloodUnitTests = new DataTable();
			
			if (xmTest.GetType().ToString().IndexOf("OrderedTest") != -1)
			{
				_testOrder = (BOL.OrderedTest)xmTest;
				IsOnlyXMatch = _testOrder.CheckIfISOnlyXMatchPossible();
			}
			else
			{
				_componentOrder = (BOL.OrderedComponent)xmTest;
				IsOnlyXMatch = _componentOrder.CheckIfISOnlyXMatchPossible();
			}

			DataTable dt = new System.Data.DataTable("XM");

			dt.Columns.Add(ARTIFICIAL.Indicator, typeof(String));
			dt.Columns.Add(TABLE.ExceptionAntigenTest.UnitId,typeof(String));
			dt.Columns.Add(ARTIFICIAL.IS, typeof(String));
			dt.Columns.Add(ARTIFICIAL.C37, typeof(String));
			dt.Columns.Add(ARTIFICIAL.AHG, typeof(String));
			dt.Columns.Add(ARTIFICIAL.CC, typeof(String));
			dt.Columns.Add(ARTIFICIAL.XMInterp, typeof(String));			
			dt.Columns.Add(ARTIFICIAL.XMComment, typeof(String));
			dt.Columns.Add(TABLE.Patient.PatientGuid, typeof(Guid));
			dt.Columns.Add(TABLE.PatientSpecimen.PatientSpecimenGuid, typeof(Guid));
			dt.Columns.Add(TABLE.OrderedTest.OrderedTestGuid, typeof(Guid));
			dt.Columns.Add(TABLE.OrderedComponent.OrderedComponentGuid, typeof(Guid));
			dt.Columns.Add(TABLE.OrderableTest.OrderableTestId, typeof(int));
			dt.Columns.Add(TABLE.BloodUnit.BloodUnitGuid, typeof(Guid));
			dt.Columns.Add(TABLE.OrderedUnit.OrderedUnitGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.XMInterpSave, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.ISGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.C37Guid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.AHGGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.XMInterpGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.ISRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.C37RowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.AHGRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.CCRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.XMInterpRowVersion, typeof(byte[]));
			dt.Columns.Add(TABLE.CannedComment.CannedCommentGuid, typeof(Guid));
			dt.Columns.Add(TABLE.OrderedTest.CprsOrderNumber);
			dt.Columns.Add(ARTIFICIAL.IsOnlyXMatch, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.PrintForms, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.PrintFormsComment);
			dt.Columns.Add(ARTIFICIAL.OrderedTestRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.UnitStatusRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.OrderedUnitRowVersion, typeof(byte[]));
			dt.Columns.Add(TABLE.OrderedUnit.SelectedDate, typeof(DateTime));
			dt.Columns.Add(ARTIFICIAL.NonStandardTestException, typeof(BOL.ExceptionReport));
			dt.Columns.Add(ARTIFICIAL.AntigenPositiveUnitException, typeof(BOL.ExceptionReport));
			dt.Columns.Add(ARTIFICIAL.MedicalDirectorApprovalException, typeof(BOL.ExceptionReport));
			dt.Columns.Add(TABLE.BloodUnitTest.CorrectedResultIndicator, typeof(bool));
			dt.Columns.Add(ARTIFICIAL.EmergencyIssueExceptions, typeof(BOL.ExceptionReport));
			dt.Columns.Add(TABLE.Rack.RackGuid, typeof(Guid));
			dt.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(String));

			if (_testOrder != null)
			{
				dtOrderedUnits = BOL.OrderedUnit.GetOrderedUnitsForRepeatXM(_testOrder.OrderedTestGuid, Guid.Empty);
				_patient = _testOrder.Patient;
				dtBloodUnitTests = BOL.BloodUnitTest.GetTestResultsForXM(_testOrder.OrderedTestGuid, Guid.Empty);
			}
			else if (_componentOrder != null)
			{
				dtOrderedUnits = BOL.OrderedUnit.GetOrderedUnitsForRepeatXM(Guid.Empty, _componentOrder.OrderedComponentGuid);
				_patient = _componentOrder.Patient;
				dtBloodUnitTests = BOL.BloodUnitTest.GetTestResultsForXM(Guid.Empty, _componentOrder.OrderedComponentGuid);
			}


			if (dtBloodUnitTests.Rows.Count > 0)
			{
				if (dtBloodUnitTests.Select(TABLE.BloodTestType.BloodTestTypeId + " = 102 OR " + TABLE.BloodTestType.BloodTestTypeId + " = 168").Length == dtBloodUnitTests.Rows.Count)
				{
					//if all tests recorded previously (for previously crossmatched units) are only interps then we are in transfusion only division
					this._partiallyCompleted = false;
				}
				else
				{
					this._partiallyCompleted = true;
					int reactivityPhase = Convert.ToInt32(dtBloodUnitTests.Rows[0][TABLE.BloodUnitTest.ReactivityPhaseCode].ToString());
					if (reactivityPhase == (int)Common.ReactivityPhase.IAT)
						this._reactivityPhase = Common.ReactivityPhase.IAT;
					else
						this._reactivityPhase = Common.ReactivityPhase.All;
				}
			}
			else
			{
				this._partiallyCompleted = false;
			}
 
			foreach (DataRow drOrderedUnit in dtOrderedUnits.Rows)
			{
				if ((_componentOrder != null && drOrderedUnit.IsNull(TABLE.OrderedUnit.CrossmatchResultCode) == false) ||
					(_testOrder != null && drOrderedUnit.IsNull(TABLE.OrderedUnit.CrossmatchResultCode) == false))
					continue;

				DataRow dr = dt.NewRow();

				dr[ARTIFICIAL.Indicator] = string.Empty;
				dr[TABLE.ExceptionAntigenTest.UnitId] = drOrderedUnit[TABLE.BloodUnit.EyeReadableUnitId];

				if (this._partiallyCompleted == true)
				{
					dr[ARTIFICIAL.IS] = DBNull.Value;
					dr[ARTIFICIAL.C37] = DBNull.Value;
					dr[ARTIFICIAL.AHG] = DBNull.Value;
					dr[ARTIFICIAL.CC] = DBNull.Value;
					dr[ARTIFICIAL.ISSave] = false;
					dr[ARTIFICIAL.C37Save] = false;
					dr[ARTIFICIAL.AHGSave] = false;
					dr[ARTIFICIAL.CCSave] = false;
					this._partiallyCompleted = true;
				}
				else
				{
					if (this._division.ServiceTypeIndicator == true)
					{
						if (this.ReactivityPhase == Common.ReactivityPhase.All)
						{
							dr[ARTIFICIAL.C37] = string.Empty;
							dr[ARTIFICIAL.CC] = string.Empty;
							dr[ARTIFICIAL.C37Save] = true;
							dr[ARTIFICIAL.CCSave] = true;
						}
						else
						{
							dr[ARTIFICIAL.C37] = DBNull.Value;
							dr[ARTIFICIAL.CC] = DBNull.Value;
							dr[ARTIFICIAL.C37Save] = false;
							dr[ARTIFICIAL.CCSave] = false;
						}
						dr[ARTIFICIAL.AHG] = string.Empty;
						dr[ARTIFICIAL.AHGSave] = true;
                        //CR 3556 enabling IS phase for AHG only
                        dr[ARTIFICIAL.IS] = string.Empty;
                        dr[ARTIFICIAL.ISSave] = true;
                    }
					else
					{
						dr[ARTIFICIAL.IS] = DBNull.Value;
						dr[ARTIFICIAL.C37] = DBNull.Value;
						dr[ARTIFICIAL.AHG] = DBNull.Value;
						dr[ARTIFICIAL.CC] = DBNull.Value;
						dr[ARTIFICIAL.ISSave] = false;
						dr[ARTIFICIAL.C37Save] = false;
						dr[ARTIFICIAL.AHGSave] = false;
						dr[ARTIFICIAL.CCSave] = false;
					}
				}

				dr[ARTIFICIAL.XMInterp] = string.Empty;
				dr[ARTIFICIAL.XMInterpSave] = true;
				dr[ARTIFICIAL.XMComment] = string.Empty;

				if (_testOrder != null)
				{
					dr[TABLE.Patient.PatientGuid] = _testOrder.Patient.PatientGuid;
					dr[TABLE.PatientSpecimen.PatientSpecimenGuid] = _testOrder.Specimen.SpecimenGuid;
					dr[TABLE.OrderedTest.OrderedTestGuid] = _testOrder.OrderedTestGuid;
					dr[TABLE.OrderedComponent.OrderedComponentGuid] = DBNull.Value;
					dr[TABLE.OrderedTest.CprsOrderNumber] = _testOrder.CPRSOrderNumber;
					dr[TABLE.OrderableTest.OrderableTestId] = System.Convert.ToInt32(Common.OrderableTest.RepeatXM);
					dr[ARTIFICIAL.OrderedTestRowVersion] = _testOrder.RowVersion;
					
					if (_testOrder.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.ResultsCorrected))
						dr[TABLE.BloodUnitTest.CorrectedResultIndicator] = true;
					else
						dr[TABLE.BloodUnitTest.CorrectedResultIndicator] = false;
				}
				else if (_componentOrder != null)
				{
					dr[TABLE.Patient.PatientGuid] = _componentOrder.Patient.PatientGuid;
					dr[TABLE.PatientSpecimen.PatientSpecimenGuid] = _componentOrder.GetSpecimen().SpecimenGuid;  // CR3114
					dr[TABLE.OrderedComponent.CprsOrderNumber] = _componentOrder.CPRSOrderNumber;
					dr[TABLE.OrderedTest.OrderedTestGuid] = DBNull.Value;
					dr[TABLE.OrderedComponent.OrderedComponentGuid] = _componentOrder.OrderedComponentGuid;
					dr[TABLE.OrderableTest.OrderableTestId] = System.Convert.ToInt32(Common.OrderableTest.XM);
					dr[ARTIFICIAL.OrderedTestRowVersion] = _componentOrder.RowVersion;
					
					if (_componentOrder.TaskStatusCode == Common.TaskStatus.ResultsCorrected)
						dr[TABLE.BloodUnitTest.CorrectedResultIndicator] = true;
					else
						dr[TABLE.BloodUnitTest.CorrectedResultIndicator] = false;
				}

				dr[TABLE.BloodUnit.BloodUnitGuid] = drOrderedUnit[TABLE.BloodUnit.BloodUnitGuid];
				dr[TABLE.OrderedUnit.OrderedUnitGuid] = drOrderedUnit[TABLE.OrderedUnit.OrderedUnitGuid];
				dr[ARTIFICIAL.OrderedUnitRowVersion] = drOrderedUnit[TABLE.OrderedUnit.RowVersion];
				dr[TABLE.OrderedUnit.SelectedDate] = drOrderedUnit[TABLE.OrderedUnit.SelectedDate];

				BOL.BloodUnitStatus UnitStatus = new BOL.BloodUnitStatus((Guid)drOrderedUnit[TABLE.BloodUnit.BloodUnitGuid]);
				dr[ARTIFICIAL.UnitStatusRowVersion] = UnitStatus.RowVersion;

				dr[ARTIFICIAL.PartiallyCompleted] = false;
				dr[ARTIFICIAL.IsOnlyXMatch] = IsOnlyXMatch;
				dr[ARTIFICIAL.IndicatorMessage] = string.Empty;
				
				if (rackGuid != Guid.Empty)
					dr[TABLE.Rack.RackGuid] = rackGuid;
				dt.Rows.Add(dr);
			}

			this.dgXMatch.ToolTipColumn = dt.Columns.Count - 1;

			return dt;
		}

		/// <summary>
		/// Sets the data source for a grid. Transfers DataTable to a DataView and passes it as
		/// a source for a grid.
		/// </summary>
		/// <param name="dt"></param>
		public void SetDataSource(DataTable dt)
		{
			if (dt.Rows.Count == 0)
			{
				this.dgXMatch.ColumnHeadersVisible = false;
				this.dgXMatch.DataSource = dt.DefaultView;
				this.btnClear.Enabled = false;
				enableInvalidation = false;
			}
			else
			{
				this.btnClear.Enabled = true;
				enableInvalidation = true;
				this.dgXMatch.ColumnHeadersVisible = true;
				this.dgXMatch.DataSource = dt.DefaultView;
				((DataView)dgXMatch.DataSource).AllowNew = false;
				((DataView)dgXMatch.DataSource).AllowDelete = false;
				this.cmbBoxComment.SelectedIndex = -1;

				this._dtXM = dt;
				for (int i=0 ; i<dt.Rows.Count ; i++)
				{
					UpdateIndicator(i);
				}
			}
		}

		/// <summary>
		/// Enables or disables the grid
		/// </summary>
		/// <param name="status"></param>
		public void SetGridStatus(bool status)
		{
			this.dgXMatch.Enabled = status;
		}

		/// <summary>
		/// Check if data on the grid is ready to be saved to the database
		/// </summary>
		/// <returns></returns>
		public bool IsReadyToSave()
		{
			DataTable dt = ((DataView)this.dgXMatch.DataSource).Table;

			if (dt.Rows.Count == 0)
				return true;

			if (this._division.ServiceTypeIndicator == true ||
				this._partiallyCompleted == true)
			{
				for (int i=0 ; i<dt.Rows.Count ; i++)
				{
					if (dt.Rows[i][ARTIFICIAL.Indicator].ToString() == "E")
						return false;
				}
			}
			else
			{
				for (int i=0 ; i<dt.Rows.Count ; i++)
				{
					if (dt.Rows[i][ARTIFICIAL.Indicator].ToString() == string.Empty)
						return false;
				}
			}

			return true;
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// Adds the custom data table style to the data grid.
		/// </summary>
		private void AddCustomDataTableStyle()
		{
			_dgTableStyle = new DataGridTableStyle();

			_dgTableStyle.AllowSorting = false;
			_dgTableStyle.DataGrid = dgXMatch;

			_dgTableStyle.HeaderFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)), true);
			_dgTableStyle.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			_dgTableStyle.MappingName = "XM";
			_dgTableStyle.RowHeadersVisible = false;
			_dgTableStyle.PreferredRowHeight = 22;
			// 
			// Indicator
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.Indicator;
			_dcTextKeyTrapCol.ReadOnly = true;
			_dcTextKeyTrapCol.Width = 20;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			// 
			// UnitId
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.HeaderText = "Unit ID";
			_dcTextBox.MappingName = TABLE.ExceptionAntigenTest.UnitId;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 95;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			_dcTextKeyTrapCol.TextBox.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			// 
			// IS
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = ARTIFICIAL.IS;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.IS;
			_dcTextKeyTrapCol.Width = 25;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);
			// 
			// 37
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = ARTIFICIAL.C37;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.C37;
			_dcTextKeyTrapCol.Width = 25;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);
			// 
			// AHG
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = ARTIFICIAL.AHG;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.AHG;
			_dcTextKeyTrapCol.Width = 30;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);
			// 
			// CC
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = ARTIFICIAL.CC;
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.CC;
			_dcTextKeyTrapCol.Width = 25;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);
			// 
			// XMInterp
			// 
			_dcTextKeyTrapCol = new controls.DataGridKeyTrapTextBoxColumn();
			_dcTextKeyTrapCol.Alignment = HorizontalAlignment.Center;
			_dcTextKeyTrapCol.HeaderText = "Interp.";
			_dcTextKeyTrapCol.MappingName = ARTIFICIAL.XMInterp;
			_dcTextKeyTrapCol.Width = 40;
			_dcTextKeyTrapCol.ProcessAcross = false;
			_dgTableStyle.GridColumnStyles.Add(_dcTextKeyTrapCol);
			_dcTextKeyTrapCol.TextBox.KeyPress += new KeyPressEventHandler(_dcTextKeyTrapCol_TextBoxKeyPress);
			_dcTextKeyTrapCol.TextBox.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			_dcTextKeyTrapCol.TextBox.TextChanged += new EventHandler(_dcTextKeyTrapCol_TextChanged);
			// 
			// XMComment
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.HeaderText = "XM Comment";
			_dcTextBox.MappingName = ARTIFICIAL.XMComment;
			_dcTextBox.Width = 90;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			_dcTextBox.TextBox.Controls.Add(cmbBoxComment);
			cmbBoxComment.BringToFront();
			cmbBoxComment.MouseDown += new System.Windows.Forms.MouseEventHandler(_dcTextKeyTrapCol_MouseClick);
			// 
			// dcPatientGUID
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.Patient.PatientGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcPatientSpecimenGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.PatientSpecimen.PatientSpecimenGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcOrderedTestGUID
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.OrderedTest.OrderedTestGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcOrderedComponentGUID
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.OrderedComponent.OrderedComponentGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcOrderableTestID
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.OrderableTest.OrderableTestId;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcBloodUnitGUID
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.BloodUnit.BloodUnitGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcOrderedUnitGUID
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.OrderedUnit.OrderedUnitGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcPartiallyCompleted
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.PartiallyCompleted;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcISSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.ISSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dc37Save
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.C37Save;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcAHGSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AHGSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcCCSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.CCSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcXMInterpSave
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.XMInterpSave;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcISGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.ISGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dc37Guid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.C37Guid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcAHGGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AHGGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcCCGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.CCGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcXMInterpGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.XMInterpGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcISRowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.ISRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dc37RowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.C37RowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcAHGRowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AHGRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcCCRowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.CCRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcXMInterpRowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.XMInterpRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcCannedCommentGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.CannedComment.CannedCommentGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcCprsOrderNumber
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.OrderedTest.CprsOrderNumber;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcIsOnlyXMatch
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.IsOnlyXMatch;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcPrintForms
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.PrintForms;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcPrintFormsComment
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.PrintFormsComment;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcRowVersionOrderedTest
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.OrderedTestRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcUnitStatusRowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.UnitStatusRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcSelectedDate
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.OrderedUnit.SelectedDate;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcOrderedUnitRowVersion
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.OrderedUnitRowVersion;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcNonStandardTestException
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.NonStandardTestException;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcAntigenPositiveUnitException
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.AntigenPositiveUnitException;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcMedicalDirectorApprovalException
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.MedicalDirectorApprovalException;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcCorrectedResultIndicator
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.BloodUnitTest.CorrectedResultIndicator;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcEmergencyIssueException
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.EmergencyIssueExceptions;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcRackGuid
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = TABLE.Rack.RackGuid;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);
			// 
			// dcIndicatorMessage
			// 
			_dcTextBox = new DataGridTextBoxColumn();
			_dcTextBox.MappingName = ARTIFICIAL.IndicatorMessage;
			_dcTextBox.ReadOnly = true;
			_dcTextBox.Width = 0;
			_dgTableStyle.GridColumnStyles.Add(_dcTextBox);

			dgXMatch.TableStyles.Add(_dgTableStyle);				
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/21/2003</CreationDate>
		///
		/// <summary>
		/// This code traps each key stroke to allow movement to the next cell for the columns that only 
		/// require a single valid key stroke.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Key Press Event Args</param>
		private void _dcTextKeyTrapCol_TextBoxKeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			try
			{
				this.OnUserActivity();

				int row = this.dgXMatch.CurrentCell.RowNumber;
				int column = this.dgXMatch.CurrentCell.ColumnNumber;
				string cellText = string.Empty;
				string cellTextFuture = string.Empty;
				string KeyChar = string.Empty;
				string regPattern = string.Empty;
			
				TextBox c = (TextBox) sender;

				cellText = c.Text;
			
				// Let backspace and enter keys bypass
				if (!char.IsLetterOrDigit(e.KeyChar))
				{
					if (column == 7 && e.KeyChar == System.Convert.ToChar(Keys.Enter))
					{
						SetNextCell();
					}

					e.Handled = !char.IsControl(e.KeyChar);
					return;
				}

				if (column == 7)
					return;
			
				// Turn single character to upper
				KeyChar = e.KeyChar.ToString().ToUpper()[0].ToString();

				// Obtain what the string will look like after key is pressed
				if (cellText.Length > 0)
				{
					cellTextFuture = cellText.Substring(0, c.SelectionStart) + KeyChar + cellText.Substring(c.SelectionStart + c.SelectionLength, cellText.Length - (c.SelectionLength + c.SelectionStart));
				}
				else
				{
					cellTextFuture = KeyChar;
				}

				// Test what type of column it is and then apply the regular expression
				if (column == 6)  // interp
				{
					regPattern = @"(\A[CDIGZ]\z)";
				}
				else if (column == 2 || column == 3 || column == 4 || column == 5)			// IS 37 AHG CC
				{
					regPattern = @"(\A[WFM01234RX]\z)";
				}

				if (Regex.IsMatch(cellTextFuture, regPattern))
				{
					//changing values in the datable causes TextChanged event to be fired
					//setting a flag to prevent it from happening
					this._keyPressEventHandled = true;
					c.Text = cellTextFuture;
					c.SelectionStart = c.SelectionLength + 1;
					DataTable dt = ((DataView)this.dgXMatch.DataSource).Table;
					dt.Rows[row][column] = c.Text;
					SetNextCell();
					UpdateIndicator(row);
					this._keyPressEventHandled = false;
				}
				else
				{
					//BR_2.28
					GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.Common.InvalidKeyPressed());
				}
			
				e.Handled = true;
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		/// <summary>
		/// This method handles entering invalid entries into the grid (CR 2792)
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void _dcTextKeyTrapCol_TextChanged(object sender, EventArgs e)
		{
			//if the grid just received focus do not continue executing this event
			if (this.dgXMatch.GridEntered == true)
			{
				this.dgXMatch.GridEntered = false;
				return;
			}

			if (this._keyPressEventHandled || this.dgXMatch.EnterKeyPressed == true)
			{
				return;
			}
			else
			{
				int row = this.dgXMatch.CurrentCell.RowNumber;
				int column = this.dgXMatch.CurrentCell.ColumnNumber;
				DataTable dt = ((DataView)this.dgXMatch.DataSource).Table;
			
				//forcing the validation of the grid
				if (sender is System.Windows.Forms.DataGridTextBox)
				{
					//if the grid cell has anything in it run the regex match
					if (((DataGridTextBox)sender).Text != "" && ((DataGridTextBox)sender).Text != "(null)")
					{
						string regPattern = "";

						// Test what type of column it is and then apply the regular expression
						if (column == 6)  // interp
						{
							regPattern = @"(\A[CDIGZ]\z)";
						}
						else if (column == 2 || column == 3 || column == 4 || column == 5)			// IS 37 AHG CC
						{
							regPattern = @"(\A[WFM01234RX]\z)";
						}

						if (Regex.IsMatch(((DataGridTextBox)sender).Text, regPattern))
						{
							//changing values in the datable causes TextChanged event to be fired
							//setting a flag to prevent it from happening
							this._keyPressEventHandled = true;
							dt.Rows[row][column] = ((DataGridTextBox)sender).Text;
							for (int i=0; i<this._dtXM.Rows.Count; i++)
							{
								UpdateIndicator(i);
							}
							this.dgXMatch.Refresh();
							OnCellChanged(EventArgs.Empty);
							this._keyPressEventHandled = false;
						}
						else
						{
							//changing values in the datable causes TextChanged event to be fired
							//setting a flag to prevent it from happening
							this._keyPressEventHandled = true;
							((DataGridTextBox)sender).Text = dt.Rows[row][column].ToString();
							this._keyPressEventHandled = false;
							//BR_2.28
							GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.Common.InvalidKeyPressed());
						}
					}
						//user hit Del key and the grid cell is blank - refresh grid, do not run regex match
					else
					{
						//changing values in the datable causes TextChanged event to be fired
						//setting a flag to prevent it from happening
						this._keyPressEventHandled = true;
						dt.Rows[row][column] = "";
						for (int i=0; i<this._dtXM.Rows.Count; i++)
						{
							UpdateIndicator(i);
						}
						this.dgXMatch.Refresh();
						OnCellChanged(EventArgs.Empty);
						this._keyPressEventHandled = false;
					}
				}
			}
		}

		/// <summary>
		/// Controls the movement of the cursor on the datagrid.
		/// </summary>
		private void SetNextCell()
		{
			int row = this.dgXMatch.CurrentCell.RowNumber;
			int col = this.dgXMatch.CurrentCell.ColumnNumber;

			if (row == this._dtXM.Rows.Count - 1)
			{
				if (col < 7 && col > 1)
				{
					this.dgXMatch.SetCurrentCell(0, col+1);
				}
				else if (col == 7)
				{
					this.dgXMatch.SetCurrentCell(0, 2);
				}
			}
			else
			{
				this.dgXMatch.SetCurrentCell(row + 1, col);
			}
		}

		/// <summary>
		/// TT_40.01, TT_40.02, BR_40.03, BR_40.14, BR_56.29
		/// </summary>
		/// <param name="row"></param>
		private void UpdateIndicator(int row)
		{
			DataRow drUpdate = this._dtXM.Rows[row];
			string systemInterp = string.Empty;

			string Interp = drUpdate[ARTIFICIAL.XMInterp].ToString();


			if (this._division.ServiceTypeIndicator == true ||
				this._partiallyCompleted == true)
			{
				string ISResult = resultLookup[drUpdate[ARTIFICIAL.IS].ToString()].ToString();
				string ThreeSevenResult = resultLookup[drUpdate[ARTIFICIAL.C37].ToString()].ToString();
				string AHGResult = resultLookup[drUpdate[ARTIFICIAL.AHG].ToString()].ToString();
				string CCResult = resultLookup[drUpdate[ARTIFICIAL.CC].ToString()].ToString();

				if ((ISResult == string.Empty || ThreeSevenResult == string.Empty || AHGResult == string.Empty || CCResult == string.Empty) && this.ReactivityPhase == Common.ReactivityPhase.All)
				{
					drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
					drUpdate[ARTIFICIAL.Indicator] = string.Empty;
					drUpdate[ARTIFICIAL.XMInterp] = "";
				}
                //CR 3556
				else if ((ISResult == string.Empty || AHGResult == string.Empty) && this.ReactivityPhase == Common.ReactivityPhase.IAT)
				{
					drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
					drUpdate[ARTIFICIAL.Indicator] = string.Empty;
					drUpdate[ARTIFICIAL.XMInterp] = "";
				}
				else
				{
					if (Interp != string.Empty)
					{
						if (this.ReactivityPhase == Common.ReactivityPhase.IAT)
						{
                            if ((ISResult == "X" && AHGResult == "N") ||
                                (ISResult == "N" && AHGResult == "N"))
                            {
                                systemInterp = "Compatible";
                            }
                            else if ((ISResult == "X" && AHGResult == "P") ||
                                     (ISResult == "N" && AHGResult == "P") ||
                                     (ISResult == "P" && AHGResult == "P") ||
                                     (ISResult == "P" && AHGResult == "N"))
                            {
                                systemInterp = "Incompatible";
                            }

                            if (((Interp == "C" || Interp == "D") && systemInterp == "Compatible") ||
                                 (Interp == "I" && systemInterp == "Incompatible"))
                            {
                                drUpdate[ARTIFICIAL.Indicator] = "V";
                                drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
                                drUpdate[ARTIFICIAL.PartiallyCompleted] = false;
                                drUpdate[ARTIFICIAL.NonStandardTestException] = DBNull.Value;
                                drUpdate[ARTIFICIAL.MedicalDirectorApprovalException] = DBNull.Value;
                            }
                            //BR_40.14
                            else if (Interp == "G" && systemInterp == "Incompatible")
                            {
                                if (drUpdate.IsNull(ARTIFICIAL.MedicalDirectorApprovalException))
                                {
                                    DlgOverrideComment dlg = new DlgOverrideComment("Crossmatch Incompatible: Give Only with Medical Director Approval", "Crossmatch Incompatible: Give Only with Medical Director Approval", "XM");

                                    dlg.RefreshParentLockTimeEvent += new EventHandler(this.UserActivity);
                                    VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
                                    dlg.ShowDialogFromLockedParent(parentForm, false);

                                    if (dlg.DialogResult == DialogResult.OK)
                                    {
                                        BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Crossmatch_incompatible_Give_only_with_MD_approval, dlg.Comment, Common.LogonUser.LogonUserName);
                                        exRep.GenerateExceptionUnitSelection((Guid)drUpdate[TABLE.BloodUnit.BloodUnitGuid], _patient, (DateTime)drUpdate[TABLE.OrderedUnit.SelectedDate], this.TestingTech);
                                        drUpdate[ARTIFICIAL.MedicalDirectorApprovalException] = exRep;
                                        drUpdate[ARTIFICIAL.Indicator] = "V";
                                        drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
                                        drUpdate[ARTIFICIAL.PartiallyCompleted] = false;
                                        drUpdate[ARTIFICIAL.NonStandardTestException] = DBNull.Value;
                                    }
                                    else
                                    {
                                        drUpdate[ARTIFICIAL.MedicalDirectorApprovalException] = DBNull.Value;
                                        drUpdate[ARTIFICIAL.XMInterp] = string.Empty;
                                        drUpdate[ARTIFICIAL.Indicator] = string.Empty;
                                        drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
                                        drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
                                        drUpdate[ARTIFICIAL.NonStandardTestException] = DBNull.Value;
                                        return;
                                    }
                                }
                                else
                                {
                                    drUpdate[ARTIFICIAL.Indicator] = "V";
                                    drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
                                    drUpdate[ARTIFICIAL.PartiallyCompleted] = false;
                                    drUpdate[ARTIFICIAL.NonStandardTestException] = DBNull.Value;
                                }
                            }
                            else if (Interp == "Z" && (systemInterp == "Compatible" || systemInterp == "Incompatible"))
                            {
                                //BR_40.18, BR_40.20
                                if (drUpdate.IsNull(ARTIFICIAL.NonStandardTestException))
                                {
                                    DlgOverrideComment dlg = new DlgOverrideComment("Inconclusive Crossmatch", "Unit crossmatch is inconclusive and a repeat crossmatch test is needed before this unit can be issued", "XM");

                                    dlg.RefreshParentLockTimeEvent += new EventHandler(this.UserActivity);
                                    VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
                                    dlg.ShowDialogFromLockedParent(parentForm, false);

                                    if (dlg.DialogResult == DialogResult.OK)
                                    {
                                        BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Inconclusive_crossmatch, dlg.Comment, Common.LogonUser.LogonUserName);
                                        if (this._testOrder != null)
                                        {
                                            exRep.GenerateExceptionInconclusiveCrossmatch((BOL.PatientOrder)this._testOrder, (Guid)drUpdate[TABLE.BloodUnit.BloodUnitGuid], systemInterp, "Inconclusive", this._testingTech);
                                        }
                                        else
                                        {
                                            exRep.GenerateExceptionInconclusiveCrossmatch((BOL.PatientOrder)this._componentOrder, (Guid)drUpdate[TABLE.BloodUnit.BloodUnitGuid], systemInterp, "Inconclusive", this._testingTech);
                                        }
                                        drUpdate[ARTIFICIAL.Indicator] = "W";
                                        drUpdate[ARTIFICIAL.IndicatorMessage] = "Unit crossmatch is inconclusive and a repeat crossmatch test is needed before this unit can be issued";
                                        drUpdate[ARTIFICIAL.PartiallyCompleted] = false;
                                        drUpdate[ARTIFICIAL.NonStandardTestException] = exRep;
                                    }
                                    else
                                    {
                                        drUpdate[ARTIFICIAL.Indicator] = string.Empty;
                                        drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
                                        drUpdate[ARTIFICIAL.XMInterp] = string.Empty;
                                        drUpdate[ARTIFICIAL.NonStandardTestException] = DBNull.Value;
                                        drUpdate[ARTIFICIAL.MedicalDirectorApprovalException] = DBNull.Value;
                                        drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
                                        return;
                                    }
                                }
                                else
                                {
                                    drUpdate[ARTIFICIAL.Indicator] = "W";
                                    drUpdate[ARTIFICIAL.IndicatorMessage] = "Unit crossmatch is inconclusive and a repeat crossmatch test is needed before this unit can be issued";
                                    drUpdate[ARTIFICIAL.PartiallyCompleted] = false;
                                    drUpdate[ARTIFICIAL.MedicalDirectorApprovalException] = DBNull.Value;
                                }
                            }
                            else
                            {
                                drUpdate[ARTIFICIAL.Indicator] = "E";
                                drUpdate[ARTIFICIAL.IndicatorMessage] = Common.StrRes.SysErrMsg.UC040.InvalidEntry().ResString;
                                drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
                                drUpdate[ARTIFICIAL.NonStandardTestException] = DBNull.Value;
                                drUpdate[ARTIFICIAL.MedicalDirectorApprovalException] = DBNull.Value;
                            }
						}
						else //All phases
						{
                            if ((ISResult == "N" && ThreeSevenResult == "X" && AHGResult == "X" && CCResult == "X") ||
                                (ISResult == "X" && ThreeSevenResult == "N" && AHGResult == "N" && CCResult == "P") ||
                                (ISResult == "X" && ThreeSevenResult == "X" && AHGResult == "N" && CCResult == "P") ||
                                (ISResult == "N" && ThreeSevenResult == "N" && AHGResult == "N" && CCResult == "P") ||
                                (ISResult == "N" && ThreeSevenResult == "X" && AHGResult == "N" && CCResult == "P"))
                            {
                                systemInterp = "Compatible";
                            }
                            else if ((ISResult == "P" && ThreeSevenResult == "X" && AHGResult == "X" && CCResult == "X") ||
                                     (ISResult == "P" && ThreeSevenResult == "X" && AHGResult == "P" && CCResult == "P") ||
                                     (ISResult == "P" && ThreeSevenResult == "X" && AHGResult == "P" && CCResult == "X") ||
                                     (ISResult == "X" && ThreeSevenResult == "P" && AHGResult == "N" && CCResult == "P") ||
                                     (ISResult == "X" && ThreeSevenResult == "N" && AHGResult == "P" && CCResult == "P") ||
                                     (ISResult == "X" && ThreeSevenResult == "N" && AHGResult == "P" && CCResult == "X") ||
                                     (ISResult == "X" && ThreeSevenResult == "P" && AHGResult == "P" && CCResult == "P") ||
                                     (ISResult == "X" && ThreeSevenResult == "P" && AHGResult == "P" && CCResult == "X") ||
                                     (ISResult == "X" && ThreeSevenResult == "X" && AHGResult == "P" && CCResult == "P") ||
                                     (ISResult == "X" && ThreeSevenResult == "X" && AHGResult == "P" && CCResult == "X") ||
                                     (ISResult == "P" && ThreeSevenResult == "N" && AHGResult == "N" && CCResult == "P") ||
                                     (ISResult == "P" && ThreeSevenResult == "P" && AHGResult == "N" && CCResult == "P") ||
                                     (ISResult == "P" && ThreeSevenResult == "P" && AHGResult == "P" && CCResult == "P") ||
                                     (ISResult == "P" && ThreeSevenResult == "P" && AHGResult == "P" && CCResult == "X") ||
                                     (ISResult == "P" && ThreeSevenResult == "N" && AHGResult == "P" && CCResult == "P") ||
                                     (ISResult == "P" && ThreeSevenResult == "N" && AHGResult == "P" && CCResult == "X") ||
                                     (ISResult == "N" && ThreeSevenResult == "P" && AHGResult == "P" && CCResult == "P") ||
                                     (ISResult == "N" && ThreeSevenResult == "P" && AHGResult == "P" && CCResult == "X") ||
                                     (ISResult == "N" && ThreeSevenResult == "N" && AHGResult == "P" && CCResult == "P") ||
                                     (ISResult == "N" && ThreeSevenResult == "N" && AHGResult == "P" && CCResult == "X") ||
                                     (ISResult == "N" && ThreeSevenResult == "P" && AHGResult == "N" && CCResult == "P") ||
                                     (ISResult == "N" && ThreeSevenResult == "X" && AHGResult == "P" && CCResult == "P") ||
                                     (ISResult == "N" && ThreeSevenResult == "X" && AHGResult == "P" && CCResult == "X") ||
                                     (ISResult == "P" && ThreeSevenResult == "X" && AHGResult == "N" && CCResult == "P"))
                            {
                                systemInterp = "Incompatible";
                            }
                            
                            //BR_40.05
                            if (((Interp == "C" || Interp == "D") && ISResult == "N" && ThreeSevenResult == "X" && AHGResult == "X" && CCResult == "X" && (bool)drUpdate[ARTIFICIAL.IsOnlyXMatch] == false) ||
                                ((Interp == "I" || Interp == "G") && ISResult == "P" && ThreeSevenResult == "X" && AHGResult == "X" && CCResult == "X" && (bool)drUpdate[ARTIFICIAL.IsOnlyXMatch] == false))
                            {
                                drUpdate[ARTIFICIAL.Indicator] = "E";
                                drUpdate[ARTIFICIAL.IndicatorMessage] = Common.StrRes.SysErrMsg.UC040.NotEligibleForISOnlyXMatch().ResString;
                                drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
                                drUpdate[ARTIFICIAL.NonStandardTestException] = DBNull.Value;
                                drUpdate[ARTIFICIAL.MedicalDirectorApprovalException] = DBNull.Value;
                            }
                            else if (((Interp == "C" || Interp == "D") && systemInterp == "Compatible") ||
                                 (Interp == "I" && systemInterp == "Incompatible"))
                            {
                                drUpdate[ARTIFICIAL.Indicator] = "V";
                                drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
                                drUpdate[ARTIFICIAL.PartiallyCompleted] = false;
                                drUpdate[ARTIFICIAL.NonStandardTestException] = DBNull.Value;
                                drUpdate[ARTIFICIAL.MedicalDirectorApprovalException] = DBNull.Value;
                            }
                            //BR_40.14
                            else if (Interp == "G" && systemInterp == "Incompatible")
                            {
                                if (drUpdate.IsNull(ARTIFICIAL.MedicalDirectorApprovalException))
                                {
                                    DlgOverrideComment dlg = new DlgOverrideComment("Crossmatch Incompatible: Give Only with Medical Director Approval", "Crossmatch Incompatible: Give Only with Medical Director Approval", "XM");

                                    dlg.RefreshParentLockTimeEvent += new EventHandler(this.UserActivity);
                                    VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
                                    dlg.ShowDialogFromLockedParent(parentForm, false);

                                    if (dlg.DialogResult == DialogResult.OK)
                                    {
                                        BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Crossmatch_incompatible_Give_only_with_MD_approval, dlg.Comment, Common.LogonUser.LogonUserName);
                                        exRep.GenerateExceptionUnitSelection((Guid)drUpdate[TABLE.BloodUnit.BloodUnitGuid], _patient, (DateTime)drUpdate[TABLE.OrderedUnit.SelectedDate], this.TestingTech);
                                        drUpdate[ARTIFICIAL.MedicalDirectorApprovalException] = exRep;
                                        drUpdate[ARTIFICIAL.Indicator] = "V";
                                        drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
                                        drUpdate[ARTIFICIAL.PartiallyCompleted] = false;
                                        drUpdate[ARTIFICIAL.NonStandardTestException] = DBNull.Value;
                                    }
                                    else
                                    {
                                        drUpdate[ARTIFICIAL.MedicalDirectorApprovalException] = DBNull.Value;
                                        drUpdate[ARTIFICIAL.XMInterp] = string.Empty;
                                        drUpdate[ARTIFICIAL.Indicator] = string.Empty;
                                        drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
                                        drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
                                        drUpdate[ARTIFICIAL.NonStandardTestException] = DBNull.Value;
                                        return;
                                    }
                                }
                                else
                                {
                                    drUpdate[ARTIFICIAL.Indicator] = "V";
                                    drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
                                    drUpdate[ARTIFICIAL.PartiallyCompleted] = false;
                                    drUpdate[ARTIFICIAL.NonStandardTestException] = DBNull.Value;
                                }
                            }
                            else if (Interp == "Z" && (systemInterp == "Compatible" || systemInterp == "Incompatible"))
                            {
                                //BR_40.18, BR_40.20
                                if (drUpdate.IsNull(ARTIFICIAL.NonStandardTestException))
                                {
                                    DlgOverrideComment dlg = new DlgOverrideComment("Inconclusive Crossmatch", "Unit crossmatch is inconclusive and a repeat crossmatch test is needed before this unit can be issued", "XM");

                                    dlg.RefreshParentLockTimeEvent += new EventHandler(this.UserActivity);
                                    VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
                                    dlg.ShowDialogFromLockedParent(parentForm, false);

                                    if (dlg.DialogResult == DialogResult.OK)
                                    {
                                        BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Inconclusive_crossmatch, dlg.Comment, Common.LogonUser.LogonUserName);
                                        if (this._testOrder != null)
                                        {
                                            exRep.GenerateExceptionInconclusiveCrossmatch((BOL.PatientOrder)this._testOrder, (Guid)drUpdate[TABLE.BloodUnit.BloodUnitGuid], systemInterp, "Inconclusive", this._testingTech);
                                        }
                                        else
                                        {
                                            exRep.GenerateExceptionInconclusiveCrossmatch((BOL.PatientOrder)this._componentOrder, (Guid)drUpdate[TABLE.BloodUnit.BloodUnitGuid], systemInterp, "Inconclusive", this._testingTech);
                                        }
                                        drUpdate[ARTIFICIAL.Indicator] = "W";
                                        drUpdate[ARTIFICIAL.IndicatorMessage] = "Unit crossmatch is inconclusive and a repeat crossmatch test is needed before this unit can be issued";
                                        drUpdate[ARTIFICIAL.PartiallyCompleted] = false;
                                        drUpdate[ARTIFICIAL.NonStandardTestException] = exRep;
                                    }
                                    else
                                    {
                                        drUpdate[ARTIFICIAL.Indicator] = string.Empty;
                                        drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
                                        drUpdate[ARTIFICIAL.XMInterp] = string.Empty;
                                        drUpdate[ARTIFICIAL.NonStandardTestException] = DBNull.Value;
                                        drUpdate[ARTIFICIAL.MedicalDirectorApprovalException] = DBNull.Value;
                                        drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
                                        return;
                                    }
                                }
                                else
                                {
                                    drUpdate[ARTIFICIAL.Indicator] = "W";
                                    drUpdate[ARTIFICIAL.IndicatorMessage] = "Unit crossmatch is inconclusive and a repeat crossmatch test is needed before this unit can be issued";
                                    drUpdate[ARTIFICIAL.PartiallyCompleted] = false;
                                    drUpdate[ARTIFICIAL.MedicalDirectorApprovalException] = DBNull.Value;
                                }
                            }
                            else if (AHGResult == "N" && (CCResult == "N" || CCResult == "X"))
                            {
                                drUpdate[ARTIFICIAL.Indicator] = "E";
                                drUpdate[ARTIFICIAL.IndicatorMessage] = Common.StrRes.SysErrMsg.Common.Dynamic("Invalid result. Check cells must have a positive result. Repeat test.").ResString;
                                drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
                                drUpdate[ARTIFICIAL.NonStandardTestException] = DBNull.Value;
                                drUpdate[ARTIFICIAL.MedicalDirectorApprovalException] = DBNull.Value;
                            }
                            else
                            {
                                drUpdate[ARTIFICIAL.Indicator] = "E";
                                drUpdate[ARTIFICIAL.IndicatorMessage] = Common.StrRes.SysErrMsg.UC040.InvalidEntry().ResString;
                                drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
                                drUpdate[ARTIFICIAL.NonStandardTestException] = DBNull.Value;
                                drUpdate[ARTIFICIAL.MedicalDirectorApprovalException] = DBNull.Value;
                            }
						}
					}
					else
					{
						drUpdate[ARTIFICIAL.Indicator] = string.Empty;
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
					}
				}
			}
			else
			{
				if (Interp != string.Empty)
				{
					if (Interp == "Z")
					{
						//BR_40.18, BR_40.20
						if (drUpdate.IsNull(ARTIFICIAL.NonStandardTestException))
						{
							DlgOverrideComment dlg = new DlgOverrideComment("Inconclusive Crossmatch", "Unit crossmatch is inconclusive and a repeat crossmatch test is needed before this unit can be issued", "XM");

                            dlg.RefreshParentLockTimeEvent += new EventHandler(this.UserActivity);
                            VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
                            dlg.ShowDialogFromLockedParent(parentForm, false); 
                            if (dlg.DialogResult == DialogResult.OK)
							{
								BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Inconclusive_crossmatch, dlg.Comment, Common.LogonUser.LogonUserName);
								if (this._testOrder != null)
								{
									exRep.GenerateExceptionInconclusiveCrossmatch((BOL.PatientOrder)this._testOrder, (Guid)drUpdate[TABLE.BloodUnit.BloodUnitGuid], systemInterp, "Inconclusive", this._testingTech);
								}
								else
								{
									exRep.GenerateExceptionInconclusiveCrossmatch((BOL.PatientOrder)this._componentOrder, (Guid)drUpdate[TABLE.BloodUnit.BloodUnitGuid], systemInterp, "Inconclusive", this._testingTech);
								}
								drUpdate[ARTIFICIAL.Indicator] = "W";
								drUpdate[ARTIFICIAL.IndicatorMessage] = "Unit crossmatch is inconclusive and a repeat crossmatch test is needed before this unit can be issued";
								drUpdate[ARTIFICIAL.PartiallyCompleted] = false;
								drUpdate[ARTIFICIAL.NonStandardTestException] = exRep;
							}
							else
							{
								drUpdate[ARTIFICIAL.Indicator] = string.Empty;
								drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
								drUpdate[ARTIFICIAL.XMInterp] = string.Empty;
								drUpdate[ARTIFICIAL.NonStandardTestException] = DBNull.Value;
							}
						}
						else
						{
							drUpdate[ARTIFICIAL.Indicator] = "W";
							drUpdate[ARTIFICIAL.IndicatorMessage] = "Unit crossmatch is inconclusive and a repeat crossmatch test is needed before this unit can be issued";
							drUpdate[ARTIFICIAL.PartiallyCompleted] = false;
						}
						drUpdate[ARTIFICIAL.MedicalDirectorApprovalException] = DBNull.Value;
					}
					//BR_40.14
					else if (Interp == "G" && drUpdate.IsNull(ARTIFICIAL.MedicalDirectorApprovalException) == true)
					{
						DlgOverrideComment dlg = new DlgOverrideComment("Crossmatch Incompatible: Give Only with Medical Director Approval", "Crossmatch Incompatible: Give Only with Medical Director Approval", "XM");

                        dlg.RefreshParentLockTimeEvent += new EventHandler(this.UserActivity);
                        VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
                        dlg.ShowDialogFromLockedParent(parentForm, false);

						if (dlg.DialogResult == DialogResult.OK)
						{
							BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Crossmatch_incompatible_Give_only_with_MD_approval, dlg.Comment, Common.LogonUser.LogonUserName);
							exRep.GenerateExceptionUnitSelection((Guid)drUpdate[TABLE.BloodUnit.BloodUnitGuid], _patient, (DateTime)drUpdate[TABLE.OrderedUnit.SelectedDate], this.TestingTech);
							drUpdate[ARTIFICIAL.MedicalDirectorApprovalException] = exRep;
						}
						else
						{
							drUpdate[ARTIFICIAL.MedicalDirectorApprovalException] = DBNull.Value;
							drUpdate[ARTIFICIAL.XMInterp] = string.Empty;
							return;
						}
						drUpdate[ARTIFICIAL.Indicator] = "V";
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
						drUpdate[ARTIFICIAL.NonStandardTestException] = DBNull.Value;
					}
					else
					{
						if (Interp != "G" && Interp != "Z")
						{
							drUpdate[ARTIFICIAL.MedicalDirectorApprovalException] = DBNull.Value;
							drUpdate[ARTIFICIAL.NonStandardTestException] = DBNull.Value;
						}
						drUpdate[ARTIFICIAL.Indicator] = "V";
						drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
					}

				}
				else
				{
					drUpdate[ARTIFICIAL.Indicator] = string.Empty;
					drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
				}
			}
			
			//BR_56.29
			if (Interp == "I" || Interp == "G" || Interp == "Z")
			{
				if (drUpdate.IsNull(ARTIFICIAL.EmergencyIssueExceptions) == true)
				{
					Common.UnitStatusCode statusCode = new BOL.BloodUnitStatus((Guid)drUpdate[TABLE.BloodUnit.BloodUnitGuid]).UnitStatusCode;
					if (statusCode == Common.UnitStatusCode.Issued ||
						statusCode == Common.UnitStatusCode.Transfused)
					{
						DlgOverrideComment dlg = new DlgOverrideComment( "Incompatible Crossmatch Result", Common.StrRes.SysErrMsg.UC056.EmergencyUnitsIssued().ResString, "PT" );

                        dlg.RefreshParentLockTimeEvent += new EventHandler(this.UserActivity);
                        VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
                        dlg.ShowDialogFromLockedParent(parentForm, false);

						if( dlg.DialogResult == DialogResult.Cancel )
						{
							drUpdate[ARTIFICIAL.XMInterp] = string.Empty;
							drUpdate[ARTIFICIAL.Indicator] = string.Empty;
							drUpdate[ARTIFICIAL.IndicatorMessage] = string.Empty;
							drUpdate[ARTIFICIAL.PartiallyCompleted] = true;
							this.dgXMatch.SetCurrentCell(this.dgXMatch.CurrentCell.RowNumber, 6);
							return;
						}
						else
						{
							BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Unit_ER_issued_testing_problem, dlg.Comment, Common.LogonUser.LogonUserName);
							exRep.GenerateExceptionEmergencyIssueUnitTest((Guid)drUpdate[TABLE.OrderedUnit.BloodUnitGuid], (Guid)drUpdate[TABLE.Patient.PatientGuid], "Crossmatch", Interp, this.TestingTech);
							drUpdate[ARTIFICIAL.EmergencyIssueExceptions] = exRep;
						}
					}
				}
			}
			else
			{
				drUpdate[ARTIFICIAL.EmergencyIssueExceptions] = DBNull.Value;
			}
			this.dgXMatch.Refresh();
		}

		/// <summary>
		/// Displays the valid values for each column in the legend.
		/// </summary>
		/// <param name="column"></param>
		public void SetValidEntries(int column)
		{		
			// Test what type of column it is and then apply the regular expression
			
			if (column == 2 || column == 3 || column == 4 || column == 5)	//IS 37 AHG CC
			{
				_validEntries = "0 = No Agglutination, 1 = 1+, 2 = 2+, 3 = 3+, 4 = 4+, W = Weak, F = Mixed Field, R = Rouleaux, M = Microscopic\nX = Not Tested";
			}
			else if (column == 6)		// XM Interp
			{
				_validEntries = "C = Crossmatch Compatible, D = Crossmatch Compatible Do Not Transfuse, I = Crossmatch Incompatible\nG = Crossmatch Incompatible: give only with Medical Director approval, Z = Crossmatch Inconclusive";
			}
			else if (column == 7)		// XM Comment
			{
				_validEntries = "Any Text";
			}
			else
			{
				_validEntries = "Read-Only";
			}
		}

		/// <summary>
		/// Clears the test results from the grid. Restores datagrid to the initial status.
		/// </summary>
        private void ClearTestResults(bool clearAll)
        {
            if (this._dtXM.Rows.Count > 0)
            {
                if (this._division.ServiceTypeIndicator == true ||
                    this._partiallyCompleted)
                {
                    foreach (DataRow drXM in this._dtXM.Rows)
                    {

                        if ((bool)drXM[ARTIFICIAL.ISSave] == true ||
                            clearAll == true)
                        {
                            drXM[ARTIFICIAL.IS] = string.Empty;
                            if (clearAll == true)
                            {
                                drXM[ARTIFICIAL.ISGuid] = DBNull.Value;
                                drXM[ARTIFICIAL.ISRowVersion] = DBNull.Value;
                                drXM[ARTIFICIAL.ISSave] = true;
                            }
                        }

                        if ((bool)drXM[ARTIFICIAL.C37Save] == true ||
                            clearAll == true)
                        {
                            drXM[ARTIFICIAL.C37] = string.Empty;
                            if (clearAll == true)
                            {
                                drXM[ARTIFICIAL.C37Guid] = DBNull.Value;
                                drXM[ARTIFICIAL.C37RowVersion] = DBNull.Value;

                                // CR 3570
                                if (this.ReactivityPhase == Common.ReactivityPhase.All)
                                {
                                    drXM[ARTIFICIAL.C37Save] = true;
                                }
                                else
                                {
                                    // This greys out the cell, C37 is already false, so no need to set it.
                                    drXM[ARTIFICIAL.C37] = DBNull.Value;
                                }
                                // CR 3570 end
                            }
                        }

                        if ((bool)drXM[ARTIFICIAL.AHGSave] == true ||
                            clearAll == true)
                        {
                            drXM[ARTIFICIAL.AHG] = string.Empty;
                            if (clearAll == true)
                            {
                                drXM[ARTIFICIAL.AHGGuid] = DBNull.Value;
                                drXM[ARTIFICIAL.AHGRowVersion] = DBNull.Value;
                                drXM[ARTIFICIAL.AHGSave] = true;
                            }
                        }

                        if ((bool)drXM[ARTIFICIAL.CCSave] == true ||
                            clearAll == true)
                        {
                            drXM[ARTIFICIAL.CC] = string.Empty;
                            if (clearAll == true)
                            {
                                drXM[ARTIFICIAL.CCGuid] = DBNull.Value;
                                drXM[ARTIFICIAL.CCRowVersion] = DBNull.Value;

                                // CR 3570
                                if (this.ReactivityPhase == Common.ReactivityPhase.All)
                                {
                                    drXM[ARTIFICIAL.CCSave] = true;
                                }
                                else
                                {
                                    // This greys out the cell, C37 is already false, so no need to set it.
                                    drXM[ARTIFICIAL.CC] = DBNull.Value;
                                }
                                // CR 3570 end
                            }
                        }

                        if ((bool)drXM[ARTIFICIAL.XMInterpSave] == true ||
                            clearAll == true)
                        {
                            drXM[ARTIFICIAL.XMInterp] = string.Empty;
                            if (clearAll == true)
                            {
                                drXM[ARTIFICIAL.XMInterpGuid] = DBNull.Value;
                                drXM[ARTIFICIAL.XMInterpRowVersion] = DBNull.Value;
                                drXM[ARTIFICIAL.XMInterpSave] = true;
                            }
                        }

                        drXM[ARTIFICIAL.XMComment] = string.Empty;
                    }
                }
                else //Transfusion-Only
                {
                    foreach (DataRow drXM in this._dtXM.Rows)
                    {
                        if ((bool)drXM[ARTIFICIAL.XMInterpSave] == true ||
                            clearAll == true)
                        {
                            drXM[ARTIFICIAL.XMInterp] = string.Empty;
                            if (clearAll == true)
                            {
                                drXM[ARTIFICIAL.XMInterpGuid] = DBNull.Value;
                                drXM[ARTIFICIAL.XMInterpRowVersion] = DBNull.Value;
                                drXM[ARTIFICIAL.XMInterpSave] = true;
                            }
                        }

                        drXM[ARTIFICIAL.XMComment] = string.Empty;
                    }
                }

                for (int i = 0; i < this._dtXM.Rows.Count; i++)
                {
                    UpdateIndicator(i);
                }
                this.dgXMatch.SetCurrentCell(0, 1);
            }
        }

		/// <summary>
		/// Copy the comment entered in combo box to the cell
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbBoxComment_Validating(object sender, System.ComponentModel.CancelEventArgs e)
		{
			try
			{
				int row = this.dgXMatch.CurrentCell.RowNumber;
				int col = this.dgXMatch.CurrentCell.ColumnNumber;

				if (col == 7)
				{
					this._dtXM.Rows[row][ARTIFICIAL.XMComment] = this.cmbBoxComment.Text;
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void dgXMatch_CurrentCellChanged(object sender, System.EventArgs e)
		{
			try
			{
				int col = this.dgXMatch.CurrentCell.ColumnNumber;
				int row = this.dgXMatch.CurrentCell.RowNumber;

				if (col == 0 || col == 1)
				{
					this.dgXMatch.SetCurrentCell(row, 2);
					return;
				}

				if (this._division.ServiceTypeIndicator == true ||
					this._partiallyCompleted == true)
				{
					if (this._dtXM.Rows[row][col] == DBNull.Value)
					{
						SetNextCell();
						return;
					}

					if (col < 2)
						this.dgXMatch.SetCurrentCell(row, 2);

					switch(this.dgXMatch.CurrentCell.ColumnNumber)
					{
						case 2:
							if ((bool)this._dtXM.Rows[row][ARTIFICIAL.ISSave] == false)
							{
								SetNextCell();
								return;
							}
							break;
						case 3:
							if ((bool)this._dtXM.Rows[row][ARTIFICIAL.C37Save] == false)
							{
								SetNextCell();
								return;
							}
							break;
						case 4:
							if ((bool)this._dtXM.Rows[row][ARTIFICIAL.AHGSave] == false)
							{
								SetNextCell();
								return;
							}
							break;
						case 5:
							if ((bool)this._dtXM.Rows[row][ARTIFICIAL.CCSave] == false)
							{
								SetNextCell();
								return;
							}
							break;
						case 6:
							if (this.ReactivityPhase == Common.ReactivityPhase.All)
							{
								if ((bool)this._dtXM.Rows[row][ARTIFICIAL.XMInterpSave] == false ||
									this._dtXM.Rows[row][ARTIFICIAL.IS].ToString().Trim() == string.Empty ||
									this._dtXM.Rows[row][ARTIFICIAL.C37].ToString().Trim() == string.Empty ||
									this._dtXM.Rows[row][ARTIFICIAL.AHG].ToString().Trim() == string.Empty ||
									this._dtXM.Rows[row][ARTIFICIAL.CC].ToString().Trim() == string.Empty)
								{
									SetNextCell();
									return;
								}
							}
							else
							{
								if ((bool)this._dtXM.Rows[row][ARTIFICIAL.XMInterpSave] == false ||
                                    this._dtXM.Rows[row][ARTIFICIAL.IS].ToString().Trim() == string.Empty || 
                                    this._dtXM.Rows[row][ARTIFICIAL.AHG].ToString().Trim() == string.Empty)
								{
									SetNextCell();
									return;
								}
							}
							break;
					}
				}
				else //Transfusion-Only
				{
					if (col < 6)
					{
						this.dgXMatch.SetCurrentCell(row, 6);
					}
				}

				if (col > 7)
					this.dgXMatch.SetCurrentCell(row, 7);
				else if (col == 7)
				{
					if ((bool)this._dtXM.Rows[row][ARTIFICIAL.XMInterpSave] == false ||
						this._dtXM.Rows[row][ARTIFICIAL.XMInterpSave].ToString() == string.Empty)
					{
						SetNextCell();
					}
					else
					{
						if (this.cmbBoxComment.Items.Count == 0)
						{
							DataTable dtCannedComments = BOL.CannedComment.GetCannedComments(this.DivisionCode, "PT");
							foreach (DataRow drComment in dtCannedComments.Rows)
							{
								this.cmbBoxComment.Items.Add(drComment[TABLE.CannedComment.CannedCommentText]);
							}
						}
						this.cmbBoxComment.Text = this._dtXM.Rows[row][ARTIFICIAL.XMComment].ToString();
						cmbBoxComment.Show();
						cmbBoxComment.Focus();
					}
				}

				for (int i=0 ; i<this._dtXM.Rows.Count ; i++)
				{
					UpdateIndicator(i);
				}

				SetValidEntries(this.dgXMatch.CurrentCell.ColumnNumber);
				OnCellChanged(EventArgs.Empty);
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void _dcTextKeyTrapCol_MouseClick(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			try
			{
				if (e.Button == MouseButtons.Right)
				{
					if (this._dtXM.Rows.Count > 0)
					{
						this.ContextMenu.Show(this, new Point(e.X, e.Y));
					}
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void dgXMatch_SizeChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (this.dgXMatch.TableStyles.Count>0)
				{
					DataGridTableStyle tblStyle = this.dgXMatch.TableStyles["XM"];
					//CR 3554
				    if (tblStyle != null)
				    {
				        tblStyle.GridColumnStyles[ARTIFICIAL.XMComment].Width = this.dgXMatch.Width -
				                                                                (tblStyle.GridColumnStyles[ARTIFICIAL.Indicator].Width +
				                                                                 tblStyle.GridColumnStyles[TABLE.ExceptionAntigenTest.UnitId].Width +
				                                                                 tblStyle.GridColumnStyles[ARTIFICIAL.IS].Width +
				                                                                 tblStyle.GridColumnStyles[ARTIFICIAL.C37].Width +
				                                                                 tblStyle.GridColumnStyles[ARTIFICIAL.AHG].Width +
				                                                                 tblStyle.GridColumnStyles[ARTIFICIAL.CC].Width +
				                                                                 tblStyle.GridColumnStyles[ARTIFICIAL.XMInterp].Width + 7);
				        this.cmbBoxComment.Width = tblStyle.GridColumnStyles[ARTIFICIAL.XMComment].Width;
				    }
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void dgXMatch_LostFocus(object sender, EventArgs e)
		{
			try
			{
				if (e.GetType().FullName == typeof(VbecsGridEventArgs).FullName)
				{
					if (((VbecsGridEventArgs)e).TabKeyPressed)
					{
						this.SelectNextControl(this.dgXMatch,true,true,false,false);
					}
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void dgXMatch_Leave(object sender, EventArgs e)
		{
			try
			{
				for (int i=0 ; i<this._dtXM.Rows.Count ; i++)
				{
					UpdateIndicator(i);
				}
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void dgXMatch_Enter(object sender, EventArgs e)
		{
			try
			{
				this.dgXMatch.SetCurrentCell(0, 2);
			}
			catch(ObjectDisposedException){/*swallow the ObjectDisposedException ocurring on a lock expiration*/}
		}

		private void btnClear_Click(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			DataTable dtInvalidBloodUnitTest = new DataTable();
			dtInvalidBloodUnitTest.Columns.Add(TABLE.BloodUnitTest.BloodUnitTestGuid, typeof(Guid));

			//CR 2995 Added new columns to make sure that invalidation is done properly
			dtInvalidBloodUnitTest.Columns.Add(TABLE.BloodUnitTest.InactivateDate, typeof(DateTime));
			dtInvalidBloodUnitTest.Columns.Add(TABLE.BloodUnitTest.InactivateUser);
			dtInvalidBloodUnitTest.Columns.Add(TABLE.BloodUnitTest.TestComments);

			dtInvalidBloodUnitTest.Columns.Add(TABLE.BloodUnitTest.RowVersion, typeof(byte[]));
			dtInvalidBloodUnitTest.Columns.Add(TABLE.BloodUnitTest.LastUpdateFunctionId, typeof(int));
			dtInvalidBloodUnitTest.Columns.Add(TABLE.BloodUnitTest.LastUpdateUser);
			foreach(DataRow drXM in this._dtXM.Rows)
			{
				if (!drXM.IsNull(ARTIFICIAL.ISGuid))
				{
					DataRow drInvalidBloodUnitTest = dtInvalidBloodUnitTest.NewRow();
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.BloodUnitTestGuid] = drXM[ARTIFICIAL.ISGuid];
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.InactivateDate] = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.InactivateUser] = Common.LogonUser.LogonUserName;
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.LastUpdateFunctionId] = (int)Common.UpdateFunction.DataGridXMatch;
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.RowVersion] = drXM[ARTIFICIAL.ISRowVersion];
					dtInvalidBloodUnitTest.Rows.Add(drInvalidBloodUnitTest);
				}
				//
				if (!drXM.IsNull(ARTIFICIAL.C37Guid))
				{
					DataRow drInvalidBloodUnitTest = dtInvalidBloodUnitTest.NewRow();
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.BloodUnitTestGuid] = drXM[ARTIFICIAL.C37Guid];
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.InactivateDate] = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.InactivateUser] = Common.LogonUser.LogonUserName;
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.LastUpdateFunctionId] = (int)Common.UpdateFunction.DataGridXMatch;
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.RowVersion] = drXM[ARTIFICIAL.C37RowVersion];
					dtInvalidBloodUnitTest.Rows.Add(drInvalidBloodUnitTest);
				}
				//
				if (!drXM.IsNull(ARTIFICIAL.AHGGuid))
				{
					DataRow drInvalidBloodUnitTest = dtInvalidBloodUnitTest.NewRow();
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.BloodUnitTestGuid] = drXM[ARTIFICIAL.AHGGuid];
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.InactivateDate] = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.InactivateUser] = Common.LogonUser.LogonUserName;
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.LastUpdateFunctionId] = (int)Common.UpdateFunction.DataGridXMatch;
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.RowVersion] = drXM[ARTIFICIAL.AHGRowVersion];
					dtInvalidBloodUnitTest.Rows.Add(drInvalidBloodUnitTest);
				}
				//
				if (!drXM.IsNull(ARTIFICIAL.CCGuid))
				{
					DataRow drInvalidBloodUnitTest = dtInvalidBloodUnitTest.NewRow();
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.BloodUnitTestGuid] = drXM[ARTIFICIAL.CCGuid];
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.InactivateDate] = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.InactivateUser] = Common.LogonUser.LogonUserName;
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.LastUpdateFunctionId] = (int)Common.UpdateFunction.DataGridXMatch;
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.RowVersion] = drXM[ARTIFICIAL.CCRowVersion];
					dtInvalidBloodUnitTest.Rows.Add(drInvalidBloodUnitTest);
				}
				//CR 2995 XMInterp needs to be invalidated along with testing results
				if (!drXM.IsNull(ARTIFICIAL.XMInterpGuid))
				{
					DataRow drInvalidBloodUnitTest = dtInvalidBloodUnitTest.NewRow();
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.BloodUnitTestGuid] = drXM[ARTIFICIAL.XMInterpGuid];
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.InactivateDate] = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.InactivateUser] = Common.LogonUser.LogonUserName;
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.LastUpdateFunctionId] = (int)Common.UpdateFunction.DataGridXMatch;
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
					drInvalidBloodUnitTest[TABLE.BloodUnitTest.RowVersion] = drXM[ARTIFICIAL.XMInterpRowVersion];
					dtInvalidBloodUnitTest.Rows.Add(drInvalidBloodUnitTest);
				}
			}

			if (dtInvalidBloodUnitTest.Rows.Count > 0)
			{
				DlgOverrideComment dlg = new DlgOverrideComment("Inactivate test results", "Do you want to inactivate test results for all units?", "PT");

                dlg.RefreshParentLockTimeEvent += new EventHandler(this.UserActivity);
                VbecsBaseForm parentForm = (VbecsBaseForm)this.FindForm();
                dlg.ShowDialogFromLockedParent(parentForm, false);

				if (dlg.DialogResult == DialogResult.OK)
				{
					//CR 2995 setting an invalidation comment
					for (int i=0;i<dtInvalidBloodUnitTest.Rows.Count;i++)
					{
						dtInvalidBloodUnitTest.Rows[i][TABLE.BloodUnitTest.TestComments] = dlg.Comment;
					}

					BOL.BloodUnitTest.InvalidatePartiallyCompletedCrossmatch(dtInvalidBloodUnitTest, this._testOrder , this._componentOrder, Common.UpdateFunction.DataGridXMatch);
					this.ClearTestResults(true);
				}
				else
					return;
			}
			else
			{
				if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC056.ClearTestResults()) == DialogResult.Yes)
				{
					this.ClearTestResults(false);
				}
				else
					return;
			}
		}

		/// <summary>
		/// Check if grid is empty (contains no test results)
		/// </summary>
		/// <returns></returns>
		public bool IsGridEmpty()
		{
			DataTable dt = ((DataView)this.dgXMatch.DataSource).Table;

			if (dt.Rows.Count == 0)
				return true;

			if (this._division.ServiceTypeIndicator == true ||
				this._partiallyCompleted == true)
			{
				foreach(DataRow dr in this._dtXM.Rows)
				{
					if (dr[ARTIFICIAL.IS].ToString().Trim() != string.Empty)
						return false;
					if (dr[ARTIFICIAL.C37].ToString().Trim() != string.Empty)
						return false;
					if (dr[ARTIFICIAL.AHG].ToString().Trim() != string.Empty)
						return false;
					if (dr[ARTIFICIAL.CC].ToString().Trim() != string.Empty)
						return false;
					if (dr.IsNull(ARTIFICIAL.XMInterp) == false)
					{
						if (dr[ARTIFICIAL.XMInterp].ToString().Trim() != string.Empty)
							return false;
					}
					if (dr.IsNull(ARTIFICIAL.XMComment) == false)
					{
						if (dr[ARTIFICIAL.XMComment].ToString().Trim() != string.Empty)
							return false;
					}
				}
			}
			else
			{
				if (this._dtXM.Rows[0][ARTIFICIAL.XMInterp].ToString().Trim() != string.Empty)
					return false;
				else
					return true;
			}

			return true;
		}
	}
}
